// ******************************************************************
// MULTIMODE DBS DEVICE
// 
// This program configures the microcontroller channel 2 (MCU-2) for use
// with the DBS device. 
//
//
// Richard Pinnell 2012
//*******************************************************************

#include <stdint.h>
#include <signal.h>
#include <msp430x20x3.h>

#define Bitime    0x8A
#define Bitime_5  0x02

unsigned char BitCnt;

char rxBuffer[5];

unsigned int dbstwo, dbsstate, dbsamp, count, RXData, RXReady, bytecount;
unsigned int pcount, p, l, k, temp;
unsigned int x, i, j, bn, n, b, r, pw, abc;

// 16-bit integers to be written to the timer module
uint16_t time1, time2;

void SetupClock(void)
{
  BCSCTL1 = CALBC1_8MHZ;                      // uses internal sub-master clock at 8MHz
  DCOCTL = CALDCO_8MHZ;                       // derives the digitally-controlled oscillator from the internal submaster clock, again at 8MHz
}

// sets up the input/output pins for the multiplexer and the transceiver interrupt signal. Remaining transceiver pins are set automatically
// in TI_CC_spi.c
void SetupIO(void)
{
// SYSTEM CONTROL PINS *******************************************
   // P1.0 
   P1DIR |= 0x01;
   P1OUT &= ~0x01;

   // P1.1 - UART signal from MCU 1  
   P1SEL &= ~0x02;                            
   P1DIR &= ~0x02;                  
   P1IES = 0x02;           
   P1IFG = 0;            
   P1IE = 0x02;     

   P1DIR |= 0x04;
   P1OUT &= ~0x04;

   P1DIR |= 0x10;
   P1OUT &= ~0x10;
   
   // P1.3 - bipolar pulse control
   P1DIR |= 0x08;
   P1OUT &= ~0x08;

   P2DIR |= 0x40;
   P2OUT &= ~0x40;                    
//**************************************************************   
}

// Sets up the DBS output pin. Current voltage levels are determined by the time value written to TACCR0, as well as the timer_A interrupt
// function.
void setupDBS(void)
{
  CCTL0 = ~CCIE;                             // CCR0 interrupt enabled
  TACCR0 = 60800;
  TACTL = TASSEL_2 + MC_1 + TACLR;                  // SMCLK, upmode  
}

// This function checks to see if a packet's been received from the receiver module. If so, it checks the packet for validity,
// and cycles through the available commands, carrying out the appropriate actions accordingly. If the command sent is invalid,
// then nothing happens.

void receive_byte()
{
  dbstwo = rxBuffer[0] & 0x0F;
  
  if ((dbstwo & 0xF0) == 0x00)
  {
    // CHANGE PW VALUE
    pw = rxBuffer[3] & 0x3F;
    time1 = pw*80;      
    
    // CHANGE FREQ VALUE      
    time2 = rxBuffer[1] & 0x3F;
    time2 = 40000/time2;
    l = (time2/80) - 1;            
    
    b = (rxBuffer[4]>>2) & 0x03;
    
    count = rxBuffer[4] & 0x03;
    for (j=0;j<count;j++) b = b * 10;
    p = b * pw;
    
    n = (rxBuffer[2]>>2) & 0x03;
    count = rxBuffer[2] & 0x03;
    for (j=0;j<count;j++) n = n * 10;
  }  
  
  // SET POSITIVE PULSES      
  if (dbstwo == 0x0C) P1OUT &= ~0x08;
  
  // SET NEGATIVE PULSES
  else if (dbstwo == 0x03) P1OUT |= 0x08;  

  else if (b == 1)
  {
    b *= 2;
    time1 /= 2;
  }    
    
}   

void SetupUART (void)
{
  TACCTL0 = OUT;			// Timer A Capture/Compare Control 0 Register: Output bit = sets the output high. TXD Idle as Mark
  TACTL = TASSEL_2 + MC_1;	// Timer A Control Register: clock source = SMCLK, up mode - counts up to TACCR0 (see below)
  TACCTL0 = CM0 + CCIE;		// Timer A Capture/Compare Control 0 Register: Capture Mode = 'no capture', and enable interrupts			
}

void wait(void)
{
  for(j=0;j<10;j++){for(i=0;i<50000;i++);}
}
int main (void)
{  
 
  WDTCTL = WDTPW + WDTHOLD;                     //stop WDT
  
  _EINT();				        // Enable interrupts   
  _BIS_SR(GIE);                                //enable interrupts       
  
  // run through the following five functions to configure the MCU and the transceiver
   SetupClock();
   SetupIO();
   SetupUART();
   x = 0;
   setupDBS(); 

   // set initial values for the variables. The DBS is initially set to 130Hz, 200uS pulse-mode

// CHANGE DBS SETTINGS HERE. CHANGE DBS SETTINGS HERE. CHANGE DBS SETTINGS HERE. CHANGE DBS SETTINGS HERE. 
// CHANGE DBS SETTINGS HERE. CHANGE DBS SETTINGS HERE. CHANGE DBS SETTINGS HERE. CHANGE DBS SETTINGS HERE. 
// CHANGE DBS SETTINGS HERE. CHANGE DBS SETTINGS HERE. CHANGE DBS SETTINGS HERE. CHANGE DBS SETTINGS HERE. 
   
   time1 = 80;
   time2 = 3077;
   n = 20;
   b = 10;
   p = 10;
   pw = 1;
   pcount = 10;
   l = 37;   

// CHANGE DBS SETTINGS HERE. CHANGE DBS SETTINGS HERE. CHANGE DBS SETTINGS HERE. CHANGE DBS SETTINGS HERE. 
// CHANGE DBS SETTINGS HERE. CHANGE DBS SETTINGS HERE. CHANGE DBS SETTINGS HERE. CHANGE DBS SETTINGS HERE. 
// CHANGE DBS SETTINGS HERE. CHANGE DBS SETTINGS HERE. CHANGE DBS SETTINGS HERE. CHANGE DBS SETTINGS HERE. 

   RXData = 0;
   bytecount = 0;
   RXReady = 0;
   abc = 0;
   
   dbstwo = 0x06;
   TACCTL0 = CCIE;
   P1OUT &= ~0x08;
   
   if (dbstwo == 0x06)
   {
     if (b == 1)
     {
       b *= 2;
       time1 /= 2;
     }
   }
   pcount = p;
   
   for(;;)
   {     
     _BIS_SR(LPM0_bits + GIE);     
     P1OUT &= ~0x10;          
     if (RXData > 0)
     {       
       rxBuffer[abc] = RXData;
       RXData = 0;
       abc++;
       
       if (abc == 5)
       {
         pcount = p;
         abc = 0;
         x = 0;

         for (i=0;i<5;i++)
         {
           temp = 0;
           temp |= (rxBuffer[i]>>7) & 0x01;
           temp |= (rxBuffer[i]>>5) & 0x02;
           temp |= (rxBuffer[i]>>3) & 0x04;
           temp |= (rxBuffer[i]>>1) & 0x08;
           temp |= (rxBuffer[i]<<1) & 0x10;
           temp |= (rxBuffer[i]<<3) & 0x20;
           temp |= (rxBuffer[i]<<5) & 0x40;
           temp |= (rxBuffer[i]<<7) & 0x80;
           rxBuffer[i] = temp;                                         
         }         
         
         if (rxBuffer[0] == 0x7F) bytecount = bytecount + 1;
         if (rxBuffer[1] == 0x7F) bytecount = bytecount + 1;
         if (rxBuffer[2] == 0x7F) bytecount = bytecount + 1;
         if (rxBuffer[3] == 0x7F) bytecount = bytecount + 1;
         if (rxBuffer[4] == 0x7F) bytecount = bytecount + 1;
         
         if (bytecount == 0)
         {
           receive_byte();                  
         }         
         else
         {
           dbstwo = 0x01;
         }                  
         bytecount = 0;                 
         RXReady = 0;

         if (dbstwo > 0x02) TACCTL0 = CCIE;  
         else TACCTL0 = ~CCIE;        
       }       
     }
     else
     {
       RXData = 0;
       SetupUART();
     }     
   }
}




// this interrupt is triggered upon reception of a UART signal. It configures the timer module
// to receive a UART byte
#pragma vector = PORT1_VECTOR
__interrupt void PORT1_ISR (void)
{
  TACCR0 = 0x45;
  RXReady = 1;
  P1IFG &= ~0x02;         
  P1IE &= ~0x02;  
  
  TACCTL0 = CCIE;
//  TACCTL0 =  CM1 + CCIS0 + OUTMOD0 + CCIE;
  BitCnt = 0x08;
}

#pragma vector=TIMERA0_VECTOR
__interrupt void Timer_A0 (void)

{  
//  P1OUT |= 0x01;
  if (RXReady == 1)
  {
    TACCR0 = Bitime;
    RXData |= (P1IN & 0x02);
    if (BitCnt > 1) RXData = RXData << 1;
    BitCnt --;
    if (BitCnt == 0)
    {
      TACCTL0 &= ~CCIE;
      RXReady = 0;
      for(i=0;i<1000;i++);
      P1IE = 0x02;
      P1IFG &= ~0x02;
      _BIC_SR_IRQ(LPM0_bits);
    }
  }  

  else    
  {    
    if (x < n)
    {      
      P1OUT &= ~0x10;
      if (pcount == 0) TACCR0 = time2;      
      
      else if (pcount <= l)
      {
        TACCR0 = time2 - (pcount*80);
        pcount = 0;
      }
      else if (pcount > l)
      {
        TACCR0 = time2 - (l*80);
        pcount -= l;
      }
      x++;
    }
    else if (x < (n+b))
    { 
      if (dbstwo == 0x06)
      {
        if (x >= (n+(b/2))) P1OUT |= 0x08;
        else P1OUT &= ~0x08;
      }      
      
      if (dbstwo > 0x02) P1OUT |= 0x10;
      TACCR0 = time1;
      x++;
      if (x == (n+b))
      {
        x = 0;
        pcount = p;
      }
    }
  }
}


// PIN ALLOCATION
//
// P1.0 - XXXXX
// P1.1 - MCU1 UART Signal
// P1.2 - XXXXX
// P1.3 - Bipolar/Monopolar Switch Input
// P1.4 - DBS Channel Pair 2
// P1.5 - 
// P1.6 - 
// P1.7 - 
// P2.6 - 
// P2.7 - 






